#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Pseudo KnightyanMod01.fsh    by   Eiffie  
//https://www.shadertoy.com/view/lls3Wf
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//pseudo knightyan by eiffie
//I have been watching knighty put together a fine render engine here:
//http://www.fractalforums.com/fragmentarium/updating-of-de-raytracer/
//but because I dropped a pc on my fast graphics card I was unable to make a video
//of it :) so I went this route and made a fake.

#ifdef GL_ES
precision mediump float;
#endif

vec3 mcol=vec3(-1.0);
mat2 rmx;
int rotater=-1;
float DE(vec3 p){//knighty's pseudo kleinian
	const vec3 CSize = vec3(0.63248,0.78632,0.875);
	float DEfactor=1.;
	for(int i=0;i<5;i++){
		if(i==rotater)p.xy=p.xy*rmx;
		p=2.*clamp(p, -CSize, CSize)-p;
		float k=max(0.70968/dot(p,p),1.);
		p*=k;DEfactor*=k;
	}
	if(mcol.r>=0.0)mcol+=abs(p);
	float rxy=length(p.xy);
	return max(rxy-0.92784, abs(rxy*p.z) / length(p))/DEfactor;
}
vec3 Normal(in vec3 p, in float px){
	vec2 v=vec2(px*0.1,0.0);
	vec3 n=normalize(vec3(DE(p+v.xyy)-DE(p-v.xyy),DE(p+v.yxy)-DE(p-v.yxy),DE(p+v.yyx)-DE(p-v.yyx)));
	return (n==n)?n:vec3(0.0);
}
float randSeed;
void randomize(vec2 c){randSeed=fract(sin(dot(c,vec2(113.421,17.329)))*3134.1234);}
float rand(){return fract(sin(randSeed++)*3143.45345);}
vec3 path(float tyme){return vec3(cos(tyme),sin(tyme),-0.65+abs(sin(tyme*0.7))*0.25)*(2.0+sin(tyme*1.7)*0.5)+vec3(0.0,0.0,1.0);}
vec4 scene(vec3 ro, vec3 rd, float pathSlider, float tyme, float pxl) {
	randomize(gl_FragCoord.xy+tyme);
	vec3 LP=path(tyme+1.0),p;
	LP.z+=pathSlider;
	ro.z-=pathSlider;
	float d=DE(ro)*0.8,t=d*rand(),nt=d,od=1.0,ft=0.0;//t=totalDist,nt=nextDistForRealDECheck,od=lastDist,ft=fogStepDist
	vec4 col=vec4(0.0,0.0,0.0,1.0);
	vec4 am,tm=vec4(-1.0);//stacks for hit alphas and dists
	for(int i=0;i<99;i++){
		//t+=d=DE(ro+rd*t);if(t>20.0 || d<0.001)break;
		if(nt>t+ft){//prepare for fog step
			p=ro+rd*(t+ft);
			p+=(LP-p)*(-p.z)/(LP.z-p.z);//sample the point on the plane z=0
		}else{//regular march 
			p=ro+rd*t;
		}
		d=DE(p);
		if(nt>t+ft){//step thru the fog and light it up
			float dL=0.05*length(ro+rd*(t+ft)-LP);//how far we step is based on distance to light
			col.rgb+=col.a*vec3(1.0,1.0,0.7)*exp(-dL*40.0)*smoothstep(0.0,0.01,d);
			if(t+ft+dL>nt){
				ft=0.0;
				t=nt;
				if(t>20.0)break;
			}else ft+=dL;
		}else{//save edge samples and march
			if(d<od && tm.w<0.0){
				float alpha=clamp(d/(pxl*t),0.0,1.0); 
				if(alpha<0.95){
					am=vec4(alpha,am.xyz);tm=vec4(t,tm.xyz);
					col.a*=alpha;
				}
			}
			od=d;
			nt=t+d*(0.6+0.2*rand());
		}
	}
	vec3 tcol=vec3(0.0);
	for(int i=0;i<4;i++){//now surface lighting from the saved stack of hits
		if(tm.x<0.0)continue;
		mcol=vec3(0.0);
		p=ro+rd*tm.x;
		vec3 N=Normal(p,pxl*tm.x),L=LP-p,scol;
		mcol=sin(mcol)*0.3+vec3(0.8,0.6,0.4);
		float ls=exp(-dot(L,L)*0.2);
		p+=L*(-p.z)/L.z;
		L=normalize(L);
		scol=ls*mcol*max(0.0,dot(N,L));
		float v=max(0.0,dot(N,-rd));
		scol+=exp(-t)*mcol*v;
		d=smoothstep(0.0,0.005,DE(p));
		scol+=ls*vec3(2.0,2.0,1.7)*max(0.0,dot(N,L))*d;
		if(rd.z<0.0 && d>0.0)scol+=ls*vec3(4.0,3.0,1.4)*pow(max(0.0,dot(reflect(rd,N),L)),5.0)*(1.0-0.25*v)*d;
		tcol=mix(scol,tcol,am.x);
		am=am.yzwx;tm=tm.yzwx;
	}
	col.rgb=clamp(col.rgb+tcol,0.0,1.0);
	return vec4(col.rgb,t);
}
mat3 lookat(vec3 fw){
	fw=normalize(fw);vec3 rt=normalize(cross(fw,vec3(0.0,0.0,1.0)));return mat3(rt,cross(rt,fw),fw);
}

void SetCamera(inout vec3 ro, inout vec3 rd, inout float pathSlider,float tyme, vec2 uv){
	ro=path(tyme);
	vec3 ta=path(tyme+0.2);ta.z+=0.1;
	rd=lookat(ta-ro)*normalize(vec3(uv,1.0));
	tyme=mod(tyme,18.85);
	rmx=mat2(cos(tyme),sin(tyme),-sin(tyme),cos(tyme));
	rotater=5-int(tyme/3.1416);
	pathSlider=1.0;
	if(rotater==0)pathSlider=cos((tyme-15.707)*2.0);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 uv=(2.0*fragCoord.xy-iResolution.xy)/iResolution.y;
	vec3 ro,rd;
	float pathSlider;
	SetCamera(ro,rd,pathSlider,iTime*0.125,uv);
	vec4 scn=scene(ro,rd,pathSlider,iTime*0.125,3.0/iResolution.y);
	fragColor = vec4(scn.rgb,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

